
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Mar 06 16:41:01 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_RSA_KG.c#1:csrc:1
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

/* .............. CRYS level includes ................. */

#include "DX_VOS_Mem.h"
#include "CRYS.h"
#include "CRYS_RSA_error.h"
#include "dx_hw_defs.h"
#include "crys_host_op_code.h"

/* .............. LLF level includes ................. */


/************************ Defines ******************************/

/* canceling the lint warning:
   Use of goto is deprecated */
/*lint --e{801} */

/************************ Enums ******************************/


/************************ Typedefs ******************************/


/************************ Global Data ******************************/

/************* Private function prototype ****************/

static CRYSError_t CRYS_RSA_GenerateVectorInRangeX931( DxUint32_t  RndSizeInBits, 
                                                       DxUint8_t  *RndVect_ptr, 
                                                       DxUint8_t  *temp_ptr );


/************************ Public Functions ******************************/

/***********************************************************************************************/
#ifndef _INTERNAL_CRYS_NO_RSA_KG_SUPPORT

/**
   @brief CRYS_RSA_KG_GenerateKeyPair generates a Pair of public and private keys on non CRT mode.
 
   @param[in] PubExp_ptr - The pointer to the public exponent (public key)
   @param[in] PubExpSizeInBytes - The public exponent size in bits.
   @param[in] KeySize  - The size of the key, in bits. Supported sizes are:
                            - for PKI with PKA HW: all 256 bit multiples between 512 - 2048;
                            - for PKI without PKA: HW all 32 bit multiples between 512 - 2112;
   @param[out] UserPrivKey_ptr - A pointer to the private key structure. 
                           This structure is used as input to the CRYS_RSA_PRIM_Decrypt API.
   @param[out] UserPubKey_ptr - A pointer to the public key structure. 
                           This structure is used as input to the CRYS_RSA_PRIM_Encrypt API.

   @return CRYSError_t - CRYS_OK,
                         CRYS_RSA_INVALID_EXPONENT_POINTER_ERROR,
                         CRYS_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
                         CRYS_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
                         CRYS_RSA_KEY_GEN_DATA_STRUCT_POINTER_INVALID,
                         CRYS_RSA_INVALID_MODULUS_SIZE,
                         CRYS_RSA_INVALID_EXPONENT_SIZE
*/

CEXPORT_C CRYSError_t CRYS_RSA_KG_GenerateKeyPair(DxUint8_t     *PubExp_ptr,
                                        DxUint16_t              PubExpSizeInBytes, 
                                        DxUint32_t              KeySize,
                                        CRYS_RSAUserPrivKey_t   *UserPrivKey_ptr,
                                        CRYS_RSAUserPubKey_t    *UserPubKey_ptr,
                                        CRYS_RSAKGData_t        *KeyGenData_ptr )
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_KG_OP_CODE, 6,
	   							 /* PARAMETERS: */
								 PubExp_ptr, PubExpSizeInBytes,
								 KeySize, 
								 UserPrivKey_ptr,
								 UserPubKey_ptr,
								 KeyGenData_ptr );

}/* END OF CRYS_RSA_KG_GenerateKeyPair */ 

                                      
/***********************************************************************************************/
/**
   @brief CRYS_RSA_KG_GenerateKeyPairCRT generates a Pair of public and private keys on CRT mode.

   @param[in] PubExp_ptr - The pointer to the public exponent (public key)
   @param[in] PubExpSizeInBytes - The public exponent size in bits. 
   @param[in] KeySize  - The size of the key, in bits. Supported sizes are:
                            - for PKI with PKA HW: all 256 bit multiples between 512 - 2048;
                            - for PKI without PKA: HW all 32 bit multiples between 512 - 2112;
   @param[out] UserPrivKey_ptr - A pointer to the private key structure. 
                           This structure is used as input to the CRYS_RSA_PRIM_Decrypt API.
   @param[out] UserPubKey_ptr - A pointer to the public key structure. 
                           This structure is used as input to the CRYS_RSA_PRIM_Encryped API.

   @return CRYSError_t - CRYS_OK,
                         CRYS_RSA_INVALID_EXPONENT_POINTER_ERROR,
                         CRYS_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
                         CRYS_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
                         CRYS_RSA_KEY_GEN_DATA_STRUCT_POINTER_INVALID,
                         CRYS_RSA_INVALID_MODULUS_SIZE,
                         CRYS_RSA_INVALID_EXPONENT_SIZE
*/

CEXPORT_C CRYSError_t CRYS_RSA_KG_GenerateKeyPairCRT(DxUint8_t     *PubExp_ptr,
                                           DxUint16_t              PubExpSizeInBytes, 
                                           DxUint32_t              KeySize,
                                           CRYS_RSAUserPrivKey_t   *UserPrivKey_ptr,
                                           CRYS_RSAUserPubKey_t    *UserPubKey_ptr,
                                           CRYS_RSAKGData_t        *KeyGenData_ptr )
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_KG_OP_CODE, 6,
	   							 /* PARAMETERS: */
								 PubExp_ptr, PubExpSizeInBytes,
								 KeySize, 
								 UserPrivKey_ptr,
								 UserPubKey_ptr,
								 KeyGenData_ptr );

}/* END OF CRYS_RSA_KG_GenerateKeyPairCRT */



#endif /*_INTERNAL_CRYS_NO_RSA_KG_SUPPORT*/
